#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

// The rendertarget to render
Texture2D RenderTargetTex : register(t0);

struct PSInput {
	float4 Position : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

#include "Common.hlsli"

float4 main(PSInput input) : SV_TARGET
{
	float4 color = float4(0, 0, 0, 0);
	
	// Accumulate neighboring values
	[unroll]
	for(int i = -kBoxBlurRadius; i <= kBoxBlurRadius; ++i) {
		color += RenderTargetTex.SampleLevel(LinearSampler, input.TexCoords, 0, int2(0, i));
	}
	color /= 1 + kBoxBlurRadius * 2;

	return color;
}